import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/application/add_service/add_service_master_provider.dart';
import 'package:admin_desktop/domain/models/data/service_data.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_refresher.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service/riverpod/service/service_provider.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service_master/riverpod/service_master/service_master_provider.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/service_master/add_service_page.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/service_master/update_service_page.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/presentation/theme/theme/theme.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/comments/widgets/no_item.dart';

import '../catalogue/widgets/service/widgets/service_item.dart';

class ServicePagee extends ConsumerStatefulWidget {
  const ServicePagee({super.key});

  @override
  ConsumerState<ServicePagee> createState() => _ServicePageState();
}

class _ServicePageState extends ConsumerState<ServicePagee> {
  late RefreshController refreshController;

  @override
  void initState() {
    refreshController = RefreshController();
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) {
        ref
            .read(serviceProvider.notifier)
            .fetchServices(context: context, isRefresh: true);
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(serviceProvider);
    final notifier = ref.read(serviceProvider.notifier);
    return Directionality(
      textDirection:
          LocalStorage.getLangLtr() ? TextDirection.ltr : TextDirection.rtl,
      child: Padding(
        padding: const EdgeInsets.all(8.0),
        child: CustomScaffold(
          body: (CustomColorSet colors) {
            return Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Row(
                  children: [
                    Text(
                      AppHelpers.getTranslation(TrKeys.service),
                      style: Style.interMedium(size: 20),
                    ),
                    const Spacer(),
                    CustomRefresher(
                        onTap: () {
                          notifier.fetchServices(
                              context: context, isRefresh: true);
                        },
                        isLoading: state.isLoading),
                    Padding(
                      padding: const EdgeInsets.all(12.0),
                      child: LoginButton(
                        bgColor: Style.black,
                        icon: Icon(
                          Remix.add_circle_line,
                          color: Style.white,
                          size: 24.r,
                        ),
                        onPressed: () {
                          showDialog(
                              context: context,
                              builder: (_) {
                                return Dialog(
                                    backgroundColor: Style.transparent,
                                    child: AddServicePage());
                              });
                          // ref.read(catalogueProvider.notifier).changeState(4);
                        },
                        title: AppHelpers.getTranslation(TrKeys.addService),
                      ),
                    )
                  ],
                ),
                Expanded(
                  child: state.isLoading
                      ? ListView.builder(
                          physics: const NeverScrollableScrollPhysics(),
                          shrinkWrap: true,
                          itemCount: 4,
                          // scrollDirection: Axis.horizontal,
                          itemBuilder: (context, index) {
                            return Column(
                              children: [
                                Container(
                                  margin: EdgeInsets.symmetric(horizontal: 8),
                                  width: double.infinity,
                                  height: 72,
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(AppConstants.radius),
                                    color: Style.shimmerBase,
                                  ),
                                ),
                                const Divider(height: 2, color: Style.white),
                              ],
                            );
                          })
                      : state.services.isEmpty
                          ? const NoItem(title: TrKeys.noService)
                          : SingleChildScrollView(
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Wrap(
                                    runSpacing: 12,
                                    spacing: 12,
                                    alignment: WrapAlignment.start,
                                    runAlignment: WrapAlignment.start,
                                    crossAxisAlignment:
                                        WrapCrossAlignment.start,
                                    children: [
                                      ...state.services.mapIndexed(
                                        (e, i) => ServiceItem(
                                          service: e.service ?? ServiceData(),
                                          onTap: () {
                                            ref
                                                .read(addServiceMasterProvider
                                                    .notifier)
                                                .setDetails(
                                                  e,
                                                )
                                                .then((v) {
                                              if (context.mounted) {
                                                showDialog(
                                                    context: context,
                                                    builder: (_) {
                                                      return Dialog(
                                                        backgroundColor: Style.transparent,
                                                        child:
                                                            UpdateServicePage(
                                                          id: state.services[i]
                                                                  .id ??
                                                              0,
                                                        ),
                                                      );
                                                    });
                                              }
                                            });
                                          },
                                          onDelete: () {
                                            ref
                                                .read(serviceMasterProvider
                                                    .notifier)
                                                .deleteService(context,
                                                    state.services[i].id).then((t){
                                                      if(context.mounted) {
                                                        notifier.fetchServices(
                                                            context: context,
                                                            isRefresh: true);
                                                      }
                                            });
                                          },
                                        ),
                                      ),
                                    ],
                                  ),
                                  16.verticalSpace,
                                  if (!state.hasMore)
                                    HasMoreButton(
                                      hasMore: state.hasMore,
                                      onViewMore: () {
                                        notifier.fetchServices(
                                            context: context);
                                      },
                                    )
                                ],
                              ),
                            ),
                ),
              ],
            );
          },
        ),
      ),
    );
  }
}
